/**
 * \file: util_lib.h
 *
 * \version: $Id: util_lib.h,v 1.38 2011/11/22 11:28:00 arun.v Exp $
 *
 * Defintions for the utility library.
 *
 * \component: Utility Library
 *
 * \author: T. Polle <tpolle(o)de.adit-jv.com>
 *
 * \copyright: (c) 2003 - 2008 ADIT Corporation
 */
#ifndef __UTIL_LIB_H_
#define __UTIL_LIB_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "adit_typedef.h"

#ifndef BUILDENV_LINUX

#include <tk/tkernel.h>

#include "util_cache.h"
#include "util_etc.h"
#include "util_list.h"
#include "util_lock.h"
#include "util_map.h"
#include "util_md5.h"
#include "util_mt_queue.h"
#include "util_queue.h"
#include "util_resolver.h"
#include "util_sme.h"
#include "util_string.h"
#include "util_tk.h"
#include "util_unicode.h"
#include "util_usb.h"
#include "util_share.h"

/**
 * \defgroup utility Utility Library
 */

IMPORT S32
UTIL_main(S32 ac, U8 **av);


/** Main error code */
#define UTIL_MERCD(er) \
          (((U32)(er)) >> 16)

/**
 * \addtogroup  util_misc
 * \{
 */

/**
 * \brief Swap the target with \a new_value conditionally.
 *
 * Swap the target with \a new_value, if \a old_value is equal to the
 * current value of target.
 *
 * \return   current value
 */
IMPORT S32
UTIL_test_swap(VP target, S32 old_value, S32 new_value);


/**
 * \brief Swap the target with \a new_value conditionally.
 *
 * Swap the target with \a new_value, if \a old_value is equal to the
 * current value of target.
 *
 * \return   \li 0,   if the operation succeeds
 *           \li 1    else
 */
IMPORT S32
UTIL_test_swap64(VP target, U64 old_value, U64 new_value);
/**
 * \brief Swap the target with \a new_value conditionally.
 *
 * Swap the target with \a new_value, if \a old_value is equal to the
 * current value of target.
 *
 * \return   TRUE on success, FALSE on error
 */
IMPORT S32
UTIL_test_swap32(VP target, S32 old_value, S32 new_value);


/**
 * \brief Get CPU core.
 *
 * Return CPU core. (Under Linux a default value is returned
 * because it is to costly to retrieve CPU core ID from
 * userspace)
 *
 *  * \return   Core ID
 */
IMPORT U8 UTIL_get_cpu_core(void);

#else

#include "util_linux_tk_types.h"

/**
 * \brief Swap the target with \a new_value conditionally.
 *
 * Swap the target with \a new_value, if \a old_value is equal to the
 * current value of target.
 *
 * \return   TRUE on success, FALSE on error
 */
IMPORT S32
UTIL_test_swap32(VP target, S32 old_value, S32 new_value);


/**
 * \brief Get CPU core.
 *
 * Return CPU core. (Under Linux a default value is returned
 * because it is to costly to retrieve CPU core ID from
 * userspace)
 *
 *  * \return   Core ID
 */
IMPORT U8 UTIL_get_cpu_core(void);


#endif


/** Number of elements in an array. */
#define UTIL_NO(array) \
    (sizeof(array) / sizeof(array[0]))

/**
 * \brief Swap the target with \a new_value.
 * 
 * \return   old value
 */
IMPORT S32
UTIL_swap(VP target, S32 new_value);


#include "util_hash.h"
#include "util_mpf.h"


/**
 * \}
 */

#ifdef __cplusplus
};
#endif

#endif /* __UTIL_LIB_H_ */
